
#ifndef DX_CONNECTIVITY_TEST
#define DX_CONNECTIVITY_TEST

/***************************************************************** 
*  @file DX_ConnectivityTest.c
*  @brief A simple HOST-SeP connectivity test for 3rd Party 
*		  application. 3rd Party application may edit this file.
*
*  @author mottig
*  @remarks Copyright (C) 2004 by Discretix Technologies Ltd.
*           All Rights reserved
*/

/************************ Includes *****************************/
#include "DX_VOS_BaseTypes.h"

#ifdef __cplusplus
extern "C"
{
#endif


/************************ Defines ******************************/

/* error code */
#define CONNECTIVITY_TEST_ERROR         0x01UL

/************************ Enums ********************************/

/************************ Typedefs  ****************************/

/************************Public Variables **********************/

/*********************** Public Functions **********************/

/****************************************************************************************************/
/* 
 * @brief This function is used as a connectivity HOST-SeP test. It sends a message with 
 *		  one parameter only (counter variable) to the SeP and then gets acknowledge message 
 *		  back from SeP with this parameter (counter variable) increased by one. 
 *
 *        The function executes the following major steps:
 *
 *        1. Build a message with one parameter -this is the counter variable.
 *
 *        2. Sends message to SeP.
 *           
 *        3. Gets response message from SeP
 *        
 *		  4. Checks if the counter variable parameter increased by one.
 *
 *        5. Exit with appropriate error message.
 *
 * @return DxUint32 - On success DX_OK is returned
 */
IMPORT_C DxUint32 DxConnectivityTest(void);
  

#ifdef __cplusplus
}
#endif

#endif  /* DX_CONNECTIVITY_TEST */
